#INCLUDE "P16F72.INC"
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Author 		:RAHUL SINGHAL                                ;
; Date 			:10/NOVEMBER/2010                             ;
; Version		:1.20(with facility to show the entered time) ;
; Title			:TIME CONTROLLED SWITCH                       ;
;                FOR 1 - 99 MINUTES                           ;
; Description	:	rb4	-	start/stop						  ;
;					rb5	-	selection button				  ;
;					rb6	-	decrement						  ;
;					rb7	-	increment						  ;
;					rc0	-	output to relay					  ;
;					rb<3:0>,ra<2:0>	-	seg0				  ;
;					rc<7:1>			-	seg1                  ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LIST P=PIC16F84 	;processor type PIC16F84A

;*************************block defination**************
        CBLOCK   h'20'
D1						;for delay
D2						;  	-do-
TEMP					;for binary to bcd conversion 
TEMP2					;	-do-
TEMP3					;	-do-
DISP					;converted bcd no of binary no in VALUE register 
SEVEN_SEG				;for seven seg display
SEVEN_DISP
VALUE					;value in binary for bcd conversion
SEG_SELECTED			;blink the desired seg , seg0 = 0; seg1 =1
MODE					;either working = 1; setting = 0
MIN						;stores the value of min left
SEC						;stores the value of sec left
ET_VALUE				;stores the enter value
        ENDC


ZERO_ 	EQU	B'00010001'
ONE_	EQU	B'01111101'
TWO_	EQU	B'00100011'
THREE_	EQU	B'00101001'
FOUR_	EQU	B'01001101'
FIVE_	EQU	B'10001001'
SIX_	EQU	B'10000001'
SEVEN_	EQU	B'00111101'
EIGHT_	EQU	B'00000001'
NINE_	EQU	B'00001001'


;************************MAIN BODY********************

	ORG		0X00
	GOTO	MAIN
	ORG		0X04
	GOTO	INT

;*****************************************************

MAIN
	MOVLW	B'11111111'
	MOVWF	PORTA
	MOVWF	PORTB
	MOVWF	PORTC
	BCF		PORTC,0
	CLRF	SEVEN_SEG
	CLRF	SEVEN_DISP
	CLRF	MIN
	CLRF	SEC
	CLRF	D1
	CLRF	D2
	CLRF	TEMP
	CLRF	TEMP2
	CLRF	TEMP3
	CLRF	DISP
	CLRF	VALUE
	CLRF	SEG_SELECTED
	CLRF	ET_VALUE
	CLRF	MODE
	BSF		STATUS,RP0				 			;	BANK 1
	MOVLW	H'FF'
	MOVWF	ADCON1				; configuring all PORTS as DIGITAL
	BCF		OPTION_REG,7				;enabling weak pull ups
	MOVLW	B'11110000'
	MOVWF	TRISB
	CLRF	TRISA
	CLRF	TRISC
	MOVLW	B'10001000'
	MOVWF	INTCON
	BCF		STATUS,RP0							;	BANK 0
DO
	BTFSC	MODE,0
	GOTO	WORKING_MODE
	BCF		PORTC,0
	CALL	BLINKING_SEG
	CALL	SECOND
WORKING_MODE
	CALL	MINUTE
	CALL	SECOND
	BSF		PORTC,0
	GOTO	DO

;****************************INT*************************    

INT

	BTFSC	PORTB,4					; RB4 for start/stop
	GOTO	SELECTION_BUTTON		; RB0 IS NOT WORKING
	BTFSC	MODE,0					; tested and working
	GOTO	CONVERT2SETTING
	BSF		MODE,0
	MOVF	ET_VALUE,W
	BTFSC	STATUS,Z				;
	GOTO	REP						; NOT TO START AT  ZERO
	MOVWF	MIN
	BSF		PORTC,0
	GOTO	REP						; as ET_VALUE = MIN , so no need to go for display as included in REP
CONVERT2SETTING
	CLRF	MODE
	BCF		PORTC,0
	CLRF	MIN						;
	CLRF	SEC						; clearing if stopped in between
	GOTO	REP

SELECTION_BUTTON

	BTFSC	PORTB,5					; RB5 for selection button
	GOTO	CHECK
	BTFSC	MODE,0
	GOTO	SHOW_ET_VALUE	
	COMF 	SEG_SELECTED,0
	ANDLW	B'00000001'
	MOVWF	SEG_SELECTED
	GOTO	REP
SHOW_ET_VALUE
	MOVF	SEC,0
	BTFSS	STATUS,Z
	GOTO	JUMP
	MOVF	MIN,0
	BTFSC	STATUS,Z
	GOTO	REP1
	DECF	MIN,1
	MOVF	SEC,0
	ADDLW	.59
	MOVWF	SEC
	GOTO	JUMP1
JUMP
	DECF	SEC,1
JUMP1
	MOVF	ET_VALUE,0
	MOVWF	VALUE
	CALL	B2BCD
	CALL	DISPLAY
	CALL	SECOND
	MOVF	MIN,0
	MOVWF	VALUE
	CALL	B2BCD
	CALL	DISPLAY
	GOTO	REP1
CHECK
	BTFSC	MODE,0
	GOTO	REP1

DECREMENT

	BTFSC	PORTB,6					; RB6 for decrement
	GOTO	INCREMENT				; tested and decrement is working on both 0 and 1 seg
	MOVF	ET_VALUE,0
	MOVWF	VALUE
	CALL 	B2BCD
	BTFSS	SEG_SELECTED,0
	GOTO 	GO1
	SWAPF	DISP,0
	ANDLW	B'00001111'
	BTFSC	STATUS,Z
	GOTO	REP
	MOVLW	.10
	SUBWF	ET_VALUE,1
	GOTO	REP
GO1
	MOVF	DISP,0
	ANDLW	B'00001111'
	BTFSC	STATUS,Z
	GOTO	REP
	DECF	ET_VALUE,1
	GOTO	REP

INCREMENT

	BTFSC	PORTB,7					; RB7 for increment
	GOTO	REP1					;tested and increment is working in both 1 and 0 seg
	MOVF	ET_VALUE,0
	MOVWF	VALUE
	CALL	B2BCD
	BTFSS	SEG_SELECTED,0
	GOTO	GO_
	SWAPF	DISP,0
	ANDLW	B'00001111'
	XORLW	B'00001001'
	BTFSC	STATUS,Z
	GOTO	REP
	MOVF	ET_VALUE,0
	ADDLW	.10
	MOVWF	ET_VALUE
	GOTO	REP
GO_
	MOVF	DISP,0
	ANDLW	B'00001111'
	XORLW	B'00001001'
	BTFSC	STATUS,Z
	GOTO	REP
	INCF	ET_VALUE,1
REP	
	MOVF	ET_VALUE,0
	MOVWF	VALUE
	CALL	B2BCD
	CALL	DISPLAY
REP1
	CALL	SWITCHING_DELAY
	BCF		INTCON,RBIF
	RETFIE

;****************************BINERY TO BCD CONVERSION**************************************

B2BCD				    ; B2BCD TESTED FROM 1-99

		CLRF	DISP	; convert binary no in VALUE Register to BCD no in DISP Register
		MOVF	VALUE,W
		MOVWF	TEMP
		MOVLW	.09
		MOVWF	TEMP2
CONTINUE	
		DECF	TEMP2,F
		BTFSC	STATUS,Z	
		RETURN				
		RLF		TEMP,F
		RLF		DISP,F
		MOVF	TEMP2,W
		XORLW	B'00000001'
		BTFSS	STATUS,Z
		CALL	CHECK_NIBBLES
		GOTO	CONTINUE
CHECK_NIBBLES
		MOVF	DISP,W
		ANDLW	B'00001111'
		MOVWF	TEMP3
		BTFSC	TEMP3,3
		GOTO	ADD0
		BTFSS	TEMP3,2
		GOTO	CHECK_OTHERNIBBLE
		BTFSC	TEMP3,1
		GOTO	ADD0
		BTFSS	TEMP3,0
		GOTO	CHECK_OTHERNIBBLE
ADD0
		MOVF	DISP,W
		ADDLW	B'00000011'
		MOVWF	DISP
CHECK_OTHERNIBBLE
		MOVF	DISP,W
		ANDLW	B'11110000'
		MOVWF	TEMP3
		SWAPF	TEMP3,1
		BTFSC	TEMP3,3
		GOTO	ADD1
		BTFSS	TEMP3,2
		RETURN
		BTFSC	TEMP3,1
		GOTO	ADD1
		BTFSS	TEMP3,0
		RETURN
ADD1
		MOVF	DISP,W
		ADDLW	B'00110000'
		MOVWF	DISP
		RETURN


;******************************display****************************
;TESTED
;SEG1 - RB<3:0>,RA<2:0>
;SEG2 -	RC<7:1>
;Display the value in DISP register to the seven segment
DISPLAY
		SWAPF	DISP,W
		ANDLW	B'00001111'			; SEG 1 display
		MOVWF	SEVEN_SEG
		BTFSS	STATUS,Z
		GOTO	SK_SEG1_1
		MOVLW	ZERO_
		MOVWF	SEVEN_DISP					
		GOTO	DISP_SEG1
SK_SEG1_1
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG1_2
		MOVLW	ONE_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG1
SK_SEG1_2
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG1_3
		MOVLW	TWO_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG1
SK_SEG1_3
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG1_4
		MOVLW	THREE_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG1
SK_SEG1_4
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG1_5
		MOVLW	FOUR_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG1
SK_SEG1_5
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG1_6
		MOVLW	FIVE_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG1
SK_SEG1_6
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG1_7
		MOVLW	SIX_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG1
SK_SEG1_7
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG1_8
		MOVLW	SEVEN_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG1
SK_SEG1_8
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG1_9
		MOVLW	EIGHT_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG1
SK_SEG1_9
		MOVLW	NINE_
		MOVWF	SEVEN_DISP
DISP_SEG1		
		BTFSS	SEVEN_DISP,1										
		GOTO	SK1_1					
		BSF		PORTC,1
		GOTO	SK2_1
SK1_1
		BCF		PORTC,1
SK2_1
		BTFSS	SEVEN_DISP,2
		GOTO	SK3_1
		BSF		PORTC,2
		GOTO	SK4_1
SK3_1
		BCF		PORTC,2
SK4_1
		BTFSS	SEVEN_DISP,3
		GOTO	SK5_1
		BSF		PORTC,3
		GOTO	SK6_1
SK5_1
		BCF		PORTC,3
SK6_1
		BTFSS	SEVEN_DISP,4
		GOTO	SK7_1
		BSF		PORTC,4
		GOTO	SK8_1
SK7_1
		BCF		PORTC,4
SK8_1
		BTFSS	SEVEN_DISP,5
		GOTO	SK9_1
		BSF		PORTC,5
		GOTO	SK10_1
SK9_1
		BCF		PORTC,5
SK10_1
		BTFSS	SEVEN_DISP,6
		GOTO	SK11_1
		BSF		PORTC,6
		GOTO	SK12_1
SK11_1
		BCF		PORTC,6
SK12_1
		BTFSS	SEVEN_DISP,7
		GOTO	SK13_1
		BSF		PORTC,7
		GOTO	SK14_1
SK13_1
		BCF		PORTC,7
SK14_1
		MOVF	DISP,W
		ANDLW	B'00001111'			; SEG 0 display
		MOVWF	SEVEN_SEG
		BTFSS	STATUS,Z
		GOTO	SK_SEG0_1
		MOVLW	ZERO_
		MOVWF	SEVEN_DISP					
		GOTO	DISP_SEG0
SK_SEG0_1
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG0_2
		MOVLW	ONE_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG0
SK_SEG0_2
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG0_3
		MOVLW	TWO_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG0
SK_SEG0_3
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG0_4
		MOVLW	THREE_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG0
SK_SEG0_4
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG0_5
		MOVLW	FOUR_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG0
SK_SEG0_5
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG0_6
		MOVLW	FIVE_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG0
SK_SEG0_6
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG0_7
		MOVLW	SIX_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG0
SK_SEG0_7
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG0_8
		MOVLW	SEVEN_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG0
SK_SEG0_8
		DECFSZ	SEVEN_SEG,F	
		GOTO	SK_SEG0_9
		MOVLW	EIGHT_
		MOVWF	SEVEN_DISP
		GOTO	DISP_SEG0
SK_SEG0_9
		MOVLW	NINE_
		MOVWF	SEVEN_DISP
DISP_SEG0
		BTFSS	SEVEN_DISP,1										
		GOTO	SK1_0					
		BSF		PORTA,0
		GOTO	SK2_0
SK1_0
		BCF		PORTA,0
SK2_0
		BTFSS	SEVEN_DISP,2
		GOTO	SK3_0
		BSF		PORTA,1
		GOTO	SK4_0
SK3_0
		BCF		PORTA,1
SK4_0
		BTFSS	SEVEN_DISP,3
		GOTO	SK5_0
		BSF		PORTA,2
		GOTO	SK6_0
SK5_0
		BCF		PORTA,2
SK6_0
		BTFSS	SEVEN_DISP,4
		GOTO	SK7_0
		BSF		PORTB,0
		GOTO	SK8_0
SK7_0
		BCF		PORTB,0
SK8_0
		BTFSS	SEVEN_DISP,5
		GOTO	SK9_0
		BSF		PORTB,1
		GOTO	SK10_0
SK9_0
		BCF		PORTB,1
SK10_0
		BTFSS	SEVEN_DISP,6
		GOTO	SK11_0
		BSF		PORTB,2
		GOTO	SK12_0
SK11_0
		BCF		PORTB,2
SK12_0
		BTFSS	SEVEN_DISP,7
		GOTO	SK13_0
		BSF		PORTB,3
		GOTO	SK14_0
SK13_0
		BCF		PORTB,3
SK14_0
		RETURN



;************************ delay of 1 sec ****************************************

SECOND   

		MOVLW  	d'246'				;(16*254+1+5+7)245+2=998,867
		MOVWF	D1
TWO
		MOVLW  	d'255'
		MOVWF	D2
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
   		DECF    D1,F
        BTFSC	STATUS,Z
		RETURN
ONE		
        DECF	D2,F
		BTFSC	STATUS,Z
		GOTO	TWO
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		GOTO ONE

;********************************* BLINKING SEGMENT****************************

BLINKING_SEG
		BTFSS	SEG_SELECTED,0
		GOTO	BLINK0SEG
		BSF		PORTC,4
		BSF		PORTC,1
		BSF		PORTC,2
		BSF		PORTC,3
		BSF		PORTC,5
		BSF		PORTC,6
		BSF		PORTC,7
		GOTO	GO2
BLINK0SEG
		BSF		PORTA,0
		BSF		PORTA,1
		BSF		PORTA,2
		BSF		PORTB,3
		BSF		PORTB,0
		BSF		PORTB,1
		BSF		PORTB,2
GO2		
		CALL 	SECOND
		CALL	DISPLAY
		RETURN

;*********************************MINUTE**********************************

MINUTE

		MOVF	SEC,0					;
		BTFSS	STATUS,Z
		GOTO 	ESCAPE
		MOVF	MIN,0
		BTFSS	STATUS,Z
		GOTO 	ESCAPE1
		BCF		MODE,0
		MOVF	ET_VALUE,0
		MOVWF	VALUE
		CALL	B2BCD
		CALL	DISPLAY
		RETURN
ESCAPE1
		DECF	MIN,1
		MOVLW	.59
		MOVWF	SEC
		MOVF	MIN,0
		MOVWF	VALUE
		CALL	B2BCD
		CALL	DISPLAY
ESCAPE
		DECF	SEC,1
		RETURN



;***************************END**********************************************
SWITCHING_DELAY

		MOVLW  	d'55'				
		MOVWF	D1
TWO_1
		MOVLW  	d'255'
		MOVWF	D2
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
   		DECF    D1,F
        BTFSC	STATUS,Z
		RETURN
ONE_1		
        DECF	D2,F
		BTFSC	STATUS,Z
		GOTO	TWO_1
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		GOTO ONE_1




	END